/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.sql.SQLException;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class NumbersTest
extends BaseTestCase {
    private static long TEST_BIGINT_VALUE = 6147483647L;

    public NumbersTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new NumbersTest("testNumbers").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    public void testNumbers() throws SQLException {
        this.rs = this.stmt.executeQuery("SELECT * from number_test");
        while (this.rs.next()) {
            long minBigInt = this.rs.getLong(1);
            long maxBigInt = this.rs.getLong(2);
            long testBigInt = this.rs.getLong(3);
            Assert.assertTrue((String)"Minimum bigint not stored correctly", (minBigInt == Long.MIN_VALUE ? 1 : 0) != 0);
            Assert.assertTrue((String)"Maximum bigint not stored correctly", (maxBigInt == Long.MAX_VALUE ? 1 : 0) != 0);
            Assert.assertTrue((String)"Test bigint not stored correctly", (TEST_BIGINT_VALUE == testBigInt ? 1 : 0) != 0);
        }
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE number_test");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE number_test (minBigInt bigint, maxBigInt bigint, testBigInt bigint)");
        this.stmt.executeUpdate("INSERT INTO number_test (minBigInt,maxBigInt,testBigInt) values (-9223372036854775808,9223372036854775807," + TEST_BIGINT_VALUE + ")");
    }
}

