/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import com.mysql.jdbc.NotImplemented;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class StatementsTest
extends BaseTestCase {
    private static final int MAX_COLUMNS_TO_TEST = 40;
    private static final int STEP = 8;
    private static final int MAX_COLUMN_LENGTH = 255;
    private static final int MIN_COLUMN_LENGTH = 10;

    public StatementsTest(String name) {
        super(name);
    }

    public static void main(String[] args) throws Exception {
        new StatementsTest("testStubbed").run();
        new StatementsTest("testInsert").run();
        new StatementsTest("testAutoIncrement").run();
        new StatementsTest("testPreparedStatement").run();
        new StatementsTest("testPreparedStatementBatch").run();
        new StatementsTest("testClose").run();
        new StatementsTest("testSelectColumns").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.stmt.executeUpdate("DROP TABLE statement_test");
        }
        catch (SQLException sqlEx) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE statement_test (id int not null primary key auto_increment, strdata1 varchar(255) not null, strdata2 varchar(255))");
        int i = 6;
        while (i < 40) {
            StringBuffer insertBuf = new StringBuffer("INSERT INTO statement_col_test_");
            StringBuffer stmtBuf = new StringBuffer("CREATE TABLE IF NOT EXISTS statement_col_test_");
            stmtBuf.append(i);
            insertBuf.append(i);
            stmtBuf.append(" (");
            insertBuf.append(" VALUES (");
            boolean firstTime = true;
            int j = 0;
            while (j < i) {
                if (!firstTime) {
                    stmtBuf.append(",");
                    insertBuf.append(",");
                } else {
                    firstTime = false;
                }
                stmtBuf.append("col_");
                stmtBuf.append(j);
                stmtBuf.append(" VARCHAR(");
                stmtBuf.append(255);
                stmtBuf.append(")");
                insertBuf.append("'");
                int numChars = (int)(Math.random() * 245.0) + 10;
                int k = 0;
                while (k < numChars) {
                    insertBuf.append("A");
                    ++k;
                }
                insertBuf.append("'");
                ++j;
            }
            stmtBuf.append(")");
            insertBuf.append(")");
            this.stmt.executeUpdate(stmtBuf.toString());
            this.stmt.executeUpdate(insertBuf.toString());
            i += 8;
        }
    }

    public void tearDown() throws Exception {
        this.stmt.executeUpdate("DROP TABLE statement_test");
        int i = 0;
        while (i < 40) {
            StringBuffer stmtBuf = new StringBuffer("DROP TABLE IF EXISTS statement_col_test_");
            stmtBuf.append(i);
            this.stmt.executeUpdate(stmtBuf.toString());
            i += 8;
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAccessorsAndMutators() throws SQLException {
        block18: {
            Assert.assertTrue((String)"Connection can not be null, and must be same connection", (this.stmt.getConnection() == this.conn ? 1 : 0) != 0);
            Statement accessorStmt = null;
            try {
                accessorStmt = this.conn.createStatement();
                accessorStmt.setMaxRows(1);
                accessorStmt.setMaxRows(0);
                accessorStmt.setMaxFieldSize(255);
                Assert.assertTrue((String)"Max field size should match what was set", (accessorStmt.getMaxFieldSize() == 255 ? 1 : 0) != 0);
                try {
                    accessorStmt.setMaxFieldSize(Integer.MAX_VALUE);
                    Assert.fail((String)"Should not be able to set max field size > max_packet_size");
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                accessorStmt.setCursorName("undef");
                accessorStmt.setEscapeProcessing(true);
                accessorStmt.setFetchDirection(1000);
                int fetchDirection = accessorStmt.getFetchDirection();
                Assert.assertTrue((String)"Set fetch direction != get fetch direction", (fetchDirection == 1000 ? 1 : 0) != 0);
                try {
                    accessorStmt.setFetchDirection(Integer.MAX_VALUE);
                    Assert.fail((String)"Should not be able to set fetch direction to invalid value");
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                try {
                    accessorStmt.setMaxRows(50000010);
                    Assert.fail((String)"Should not be able to set max rows > 50000000");
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                try {
                    accessorStmt.setMaxRows(Integer.MIN_VALUE);
                    Assert.fail((String)"Should not be able to set max rows < 0");
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                int fetchSize = this.stmt.getFetchSize();
                try {
                    accessorStmt.setFetchSize(Integer.MAX_VALUE);
                    Assert.fail((String)"Should not be able to set FetchSize > max rows");
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                try {
                    accessorStmt.setFetchSize(-2);
                    Assert.fail((String)"Should not be able to set FetchSize < 0");
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                Assert.assertTrue((String)"Fetch size before invalid setFetchSize() calls should match fetch size now", (fetchSize == this.stmt.getFetchSize() ? 1 : 0) != 0);
                Object var6_11 = null;
                if (accessorStmt == null) break block18;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                if (accessorStmt != null) {
                    try {
                        accessorStmt.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                    accessorStmt = null;
                }
                throw throwable;
            }
            try {
                accessorStmt.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            accessorStmt = null;
            {
            }
        }
    }

    public void testSelectColumns() throws SQLException {
        int i = 6;
        while (i < 40) {
            long start = System.currentTimeMillis();
            this.rs = this.stmt.executeQuery("SELECT * from statement_col_test_" + i);
            if (this.rs.next()) {
                // empty if block
            }
            long end = System.currentTimeMillis();
            System.out.println(i + " columns = " + (end - start));
            i += 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutoIncrement() throws SQLException {
        block12: {
            try {
                this.stmt = this.conn.createStatement(1003, 1007);
                this.stmt.setFetchSize(Integer.MIN_VALUE);
                this.stmt.executeUpdate("INSERT INTO statement_test (strdata1) values ('blah')");
                int autoIncKeyFromApi = -1;
                this.rs = this.stmt.getGeneratedKeys();
                if (this.rs.next()) {
                    autoIncKeyFromApi = this.rs.getInt(1);
                } else {
                    Assert.fail((String)"Failed to retrieve AUTO_INCREMENT using Statement.getGeneratedKeys()");
                }
                this.rs.close();
                int autoIncKeyFromFunc = -1;
                this.rs = this.stmt.executeQuery("SELECT LAST_INSERT_ID()");
                if (this.rs.next()) {
                    autoIncKeyFromFunc = this.rs.getInt(1);
                } else {
                    Assert.fail((String)"Failed to retrieve AUTO_INCREMENT using LAST_INSERT_ID()");
                }
                if (autoIncKeyFromApi != -1 && autoIncKeyFromFunc != -1) {
                    Assert.assertTrue((String)("Key retrieved from API (" + autoIncKeyFromApi + ") does not match key retrieved from LAST_INSERT_ID() " + autoIncKeyFromFunc + ") function"), (autoIncKeyFromApi == autoIncKeyFromFunc ? 1 : 0) != 0);
                } else {
                    Assert.fail((String)"AutoIncrement keys were '0'");
                }
                Object var4_3 = null;
                if (this.rs == null) break block12;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.rs = null;
                throw throwable;
            }
            try {
                this.rs.close();
                break block12;
            }
            catch (Exception ex) {
                // empty catch block
            }
            {
            }
        }
        this.rs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClose() throws SQLException {
        boolean exceptionAfterClosed;
        Statement closeStmt;
        block8: {
            closeStmt = null;
            exceptionAfterClosed = false;
            try {
                closeStmt = this.conn.createStatement();
                closeStmt.close();
                try {
                    closeStmt.executeQuery("SELECT 1");
                }
                catch (SQLException sqlEx) {
                    exceptionAfterClosed = true;
                }
                Object var5_4 = null;
                if (closeStmt == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (closeStmt != null) {
                    try {
                        closeStmt.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                }
                closeStmt = null;
                throw throwable;
            }
            try {
                closeStmt.close();
                break block8;
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            {
            }
        }
        closeStmt = null;
        Assert.assertTrue((String)"Operations not allowed on Statement after .close() is called!", (boolean)exceptionAfterClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testInsert() throws SQLException {
        block19: {
            try {
                block18: {
                    Object var6_11;
                    boolean autoCommit;
                    block17: {
                        Object var4_2;
                        autoCommit = this.conn.getAutoCommit();
                        try {
                            this.conn.setAutoCommit(false);
                            this.stmt.executeUpdate("SELECT * FROM statement_test");
                            var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            this.conn.setAutoCommit(autoCommit);
                            throw throwable;
                        }
                        this.conn.setAutoCommit(autoCommit);
                        {
                            break block17;
                            catch (SQLException sqlEx) {
                                Assert.assertTrue((String)"Exception thrown for unknown reason", (boolean)sqlEx.getSQLState().equalsIgnoreCase("01S03"));
                                var4_2 = null;
                                this.conn.setAutoCommit(autoCommit);
                            }
                        }
                    }
                    try {
                        this.conn.setAutoCommit(false);
                        this.stmt.executeQuery("UPDATE statement_test SET strdata1='blah' WHERE 1=0");
                        var6_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_12 = null;
                        this.conn.setAutoCommit(autoCommit);
                        throw throwable;
                    }
                    this.conn.setAutoCommit(autoCommit);
                    {
                        break block18;
                        catch (SQLException sqlEx) {
                            Assert.assertTrue((String)"Exception thrown for unknown reason", (boolean)sqlEx.getSQLState().equalsIgnoreCase("S1009"));
                            var6_11 = null;
                            this.conn.setAutoCommit(autoCommit);
                        }
                    }
                }
                int i = 0;
                while (i < 10) {
                    int updateCount = this.stmt.executeUpdate("INSERT INTO statement_test (strdata1,strdata2) values ('abcdefg', 'poi')");
                    Assert.assertTrue((String)("Update count must be '1', was '" + updateCount + "'"), (updateCount == 1 ? 1 : 0) != 0);
                    ++i;
                }
                this.stmt.executeUpdate("INSERT INTO statement_test (strdata1, strdata2) values ('a', 'a'), ('b', 'b'), ('c', 'c')");
                this.rs = this.stmt.getGeneratedKeys();
                int updateCountFromProtocol = 0;
                if (this.rs.next()) {
                    updateCountFromProtocol = this.rs.getInt(1);
                }
                this.rs.close();
                this.rs = this.stmt.executeQuery("SELECT LAST_INSERT_ID()");
                int updateCountFromServer = 0;
                if (this.rs.next()) {
                    updateCountFromServer = this.rs.getInt(1);
                }
                System.out.println("Update count from server: " + updateCountFromServer);
                Object var8_14 = null;
                if (this.rs == null) break block19;
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.rs = null;
                throw throwable;
            }
            try {
                this.rs.close();
                break block19;
            }
            catch (Exception ex) {
                // empty catch block
            }
            {
            }
        }
        this.rs = null;
    }

    public void testPreparedStatement() throws SQLException {
        this.stmt.executeUpdate("INSERT INTO statement_test (id, strdata1,strdata2) values (999,'abcdefg', 'poi')");
        this.pstmt = this.conn.prepareStatement("UPDATE statement_test SET strdata1=?, strdata2=? where id=?");
        this.pstmt.setString(1, "iop");
        this.pstmt.setString(2, "higjklmn");
        this.pstmt.setInt(3, 999);
        int updateCount = this.pstmt.executeUpdate();
        Assert.assertTrue((String)("Update count must be '1', was '" + updateCount + "'"), (updateCount == 1 ? 1 : 0) != 0);
    }

    public void testPreparedStatementBatch() throws SQLException {
        this.pstmt = this.conn.prepareStatement("INSERT INTO statement_test (strdata1, strdata2) VALUES (?,?)");
        int i = 0;
        while (i < 10) {
            this.pstmt.setString(1, "batch_" + i);
            this.pstmt.setString(2, "batch_" + i);
            this.pstmt.addBatch();
            ++i;
        }
        int[] updateCounts = this.pstmt.executeBatch();
        int i2 = 0;
        while (i2 < updateCounts.length) {
            Assert.assertTrue((String)("Update count must be '1', was '" + updateCounts[i2] + "'"), (updateCounts[i2] == 1 ? 1 : 0) != 0);
            ++i2;
        }
    }

    public void testStubbed() throws SQLException {
        try {
            this.stmt.getResultSetHoldability();
        }
        catch (NotImplemented notImplemented) {
            // empty catch block
        }
    }

    static {
        MAX_COLUMNS_TO_TEST = 40;
        STEP = 8;
        MAX_COLUMN_LENGTH = 255;
        MIN_COLUMN_LENGTH = 10;
    }
}

