/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.sql.SQLException;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class TransactionTest
extends BaseTestCase {
    private static final double DOUBLE_CONST = 25.4312;
    private static final double EPSILON = 1.0E-7;

    public TransactionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new TransactionTest("testTransaction").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransaction() throws SQLException {
        try {
            this.conn.setAutoCommit(false);
            this.stmt.executeUpdate("INSERT INTO trans_test (id, decdata) VALUES (1, 1.0)");
            this.conn.rollback();
            this.rs = this.stmt.executeQuery("SELECT * from trans_test");
            boolean hasResults = this.rs.next();
            Assert.assertTrue((String)"Results returned, rollback to empty table failed", (!hasResults ? 1 : 0) != 0);
            this.stmt.executeUpdate("INSERT INTO trans_test (id, decdata) VALUES (2, 25.4312)");
            this.conn.commit();
            this.rs = this.stmt.executeQuery("SELECT * from trans_test where id=2");
            hasResults = this.rs.next();
            Assert.assertTrue((String)"No rows in table after INSERT", (boolean)hasResults);
            double doubleVal = this.rs.getDouble(2);
            double delta = Math.abs(25.4312 - doubleVal);
            Assert.assertTrue((String)"Double value returned != 25.4312", (delta < 1.0E-7 ? 1 : 0) != 0);
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.conn.setAutoCommit(true);
            throw throwable;
        }
        this.conn.setAutoCommit(true);
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE trans_test");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE trans_test (id INT NOT NULL PRIMARY KEY, decdata DOUBLE) TYPE=InnoDB");
    }

    static {
        DOUBLE_CONST = 25.4312;
        EPSILON = 1.0E-7;
    }
}

