/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class TraversalTest
extends BaseTestCase {
    public TraversalTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new TraversalTest("testTransaction").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testTraversal() throws SQLException {
        Statement scrollableStmt = null;
        try {
            scrollableStmt = this.conn.createStatement(1005, 1007);
            this.rs = scrollableStmt.executeQuery("SELECT * FROM TRAVERSAL ORDER BY pos");
            int count = 0;
            this.rs.beforeFirst();
            boolean forwardOk = true;
            while (this.rs.next()) {
                int pos = this.rs.getInt("POS");
                pos = this.rs.getInt("pos");
                pos = this.rs.getInt("Pos");
                pos = this.rs.getInt("POs");
                pos = this.rs.getInt("PoS");
                pos = this.rs.getInt("pOS");
                pos = this.rs.getInt("pOs");
                pos = this.rs.getInt("poS");
                if (pos != count) {
                    forwardOk = false;
                }
                ++count;
            }
            Assert.assertTrue((String)("Only traversed " + count + " / 100 rows"), (boolean)forwardOk);
            boolean isAfterLast = this.rs.isAfterLast();
            Assert.assertTrue((String)"ResultSet.isAfterLast() failed", (boolean)isAfterLast);
            this.rs.afterLast();
            count = 99;
            boolean reverseOk = true;
            while (this.rs.previous()) {
                int pos = this.rs.getInt("pos");
                if (pos != count) {
                    reverseOk = false;
                }
                --count;
            }
            Assert.assertTrue((String)"ResultSet.previous() failed", (boolean)reverseOk);
            boolean isFirst = this.rs.isFirst();
            Assert.assertTrue((String)"ResultSet.isFirst() failed", (boolean)isFirst);
            this.rs.absolute(50);
            int pos = this.rs.getInt("pos");
            Assert.assertTrue((String)"ResultSet.absolute() failed", (pos == 49 ? 1 : 0) != 0);
            boolean onResultSet = this.rs.absolute(200);
            Assert.assertTrue((String)"ResultSet.absolute() to point off result set failed", (!onResultSet ? 1 : 0) != 0);
            onResultSet = this.rs.absolute(100);
            Assert.assertTrue((String)"ResultSet.absolute() from off rs to on rs failed", (boolean)onResultSet);
            onResultSet = this.rs.absolute(-99);
            Assert.assertTrue((String)"ResultSet.absolute(-99) failed", (boolean)onResultSet);
            Assert.assertTrue((String)"ResultSet absolute(-99) failed", (this.rs.getInt(1) == 1 ? 1 : 0) != 0);
            Object var10_9 = null;
            if (scrollableStmt == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (scrollableStmt == null) throw throwable;
            try {
                scrollableStmt.close();
                throw throwable;
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            scrollableStmt.close();
            return;
        }
        catch (SQLException sqlEx) {}
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE TRAVERSAL");
        }
        catch (SQLException SQLE) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE TRAVERSAL (pos int PRIMARY KEY, stringdata CHAR(32))");
        int i = 0;
        while (i < 100) {
            this.stmt.executeUpdate("INSERT INTO TRAVERSAL VALUES (" + i + ", 'StringData')");
            ++i;
        }
    }
}

