/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class UpdatabilityTest
extends BaseTestCase {
    public UpdatabilityTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new UpdatabilityTest("testUpdatability").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testUpdatability() throws SQLException {
        Statement scrollableStmt = null;
        try {
            scrollableStmt = this.conn.createStatement(1004, 1008);
            this.rs = scrollableStmt.executeQuery("SELECT * FROM UPDATABLE ORDER BY pos1");
            int numCols = this.rs.getMetaData().getColumnCount();
            while (this.rs.next()) {
                int rowPos = this.rs.getInt(1);
                this.rs.updateString(3, "New Data" + (100 - rowPos));
                this.rs.updateRow();
            }
            this.rs.moveToInsertRow();
            this.rs.updateInt(1, 400);
            this.rs.updateInt(2, 400);
            this.rs.updateString(3, "New Data-300");
            this.rs.insertRow();
            this.rs.close();
            this.rs = scrollableStmt.executeQuery("SELECT * FROM UPDATABLE ORDER BY pos1");
            boolean dataGood = true;
            while (this.rs.next()) {
                int rowPos = this.rs.getInt(1);
                if (this.rs.getString(3).equals("New Data" + (100 - rowPos))) continue;
                dataGood = false;
            }
            Assert.assertTrue((String)"Updates failed", (boolean)dataGood);
            int newPrimaryKeyId = 99999;
            this.rs.absolute(1);
            this.rs.updateInt(1, newPrimaryKeyId);
            this.rs.updateRow();
            int savedPrimaryKeyId = this.rs.getInt(1);
            Assert.assertTrue((String)"Updated primary key does not match", (newPrimaryKeyId == savedPrimaryKeyId ? 1 : 0) != 0);
            this.rs.close();
            Object var7_6 = null;
            if (scrollableStmt == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (scrollableStmt == null) throw throwable;
            try {
                scrollableStmt.close();
                throw throwable;
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            scrollableStmt.close();
            return;
        }
        catch (SQLException sqlEx) {}
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE UPDATABLE");
        }
        catch (SQLException SQLE) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE UPDATABLE (pos1 int not null, pos2 int not null, char_field VARCHAR(32), PRIMARY KEY (pos1, pos2))");
        int i = 0;
        while (i < 100) {
            this.stmt.executeUpdate("INSERT INTO UPDATABLE VALUES (" + i + ", " + i + ",'StringData" + i + "')");
            ++i;
        }
    }
}

