/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache;


import org.jboss.logging.Logger;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/**
 * Fully qualified name. Essentially a list of relative names, from root
 * to a given node. This class is immutable.
 *
 * @version $Revision: 1.6.2.6 $
 */
public class Fqn implements Cloneable, Externalizable {
   static Logger logger_=Logger.getLogger(Fqn.class.getName());
   List l=new ArrayList(5);



   public Fqn() {
   }

   public Fqn(Object name) {
      add(name);
   }

   public Fqn(List names) {
      for(Iterator it=names.iterator(); it.hasNext();) {
         Object name=it.next();
         add(name);
      }
   }

   public Fqn(Object[] names) {
      if(names != null)
         for(int i=0; i < names.length; i++)
            add(names[i]);
   }

   public Fqn(Fqn base, Object relative_name) {
      l.addAll(base.l);
      l.add(relative_name);
   }

   public Fqn(Fqn base, Fqn relative) {
      l.addAll(base.l);
      l.addAll(relative.l);
   }

   public static Fqn fromString(String fqn) {
      Fqn retval=new Fqn();
      retval.addFqn(fqn);
      return retval;
   }

   private void add(Object relative_name) {
      l.add(relative_name);
   }

   /**
    * Obtain a child Fqn from a sub-index.
    *
    * @param index where is the last index of child fqn
    * @return A Fqn child object.
    */
   public Fqn getFqnChild(int index) {
      List list=l.subList(0, index);
      return new Fqn(list.toArray());
   }

   /**
    * Constructs an Fqn out of a string such as "/a/b/c"
    *
    * @param fqn
    */
   public void addFqn(String fqn) {
      String child_name;
      StringTokenizer tok;

      if(fqn == null) return;
      tok=new StringTokenizer(fqn, TreeCache.SEPARATOR);
      while(tok.hasMoreTokens()) {
         child_name=tok.nextToken();
         add(child_name);
      }
   }

   public Fqn add(List names) {
      if(names != null)
         l.addAll(names);
      return this;
   }

   public int size() {
      return l.size();
   }

   public Object get(int index) {
      return l.get(index);
   }


   public Object clone() {
      return new Fqn(l);
   }

   public boolean equals(Object obj) {
      Fqn other;
      Object o1, o2;
      int len;

      if(obj == null)
         return false;
      other=(Fqn)obj; // might throw a ClassCastException
      if(other.size() != (len=size()))
         return false;
      for(int i=0; i < len; i++) {
         o1=l.get(i);
         o2=other.get(i);
         if(o1 == null && o2 != null) {
            return false;
         }
         if(o1 != null && !o1.equals(o2)) {
            return false;
         }
      }
      return true;
   }

   public int hashCode() {
      int hash_code=0;
      Object o;

      for(Iterator it=l.iterator(); it.hasNext();) {
         o=it.next();
         hash_code+=o == null ? 0 : o.hashCode();
      }
      return hash_code;
   }

   public String toString() {
      StringBuffer sb=new StringBuffer();
      for(Iterator it=l.iterator(); it.hasNext();) {
         sb.append(TreeCache.SEPARATOR).append(it.next());
      }
      return sb.length() == 0 ? TreeCache.SEPARATOR : sb.toString();
   }


   public void writeExternal(ObjectOutput out) throws IOException {
      out.writeObject(l);
   }

   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
      l=(List)in.readObject();
   }


   /**
    * Check if current fqn is child of parentFqn
    *
    * @param parentFqn
    * @return
    */
   public boolean isChildOf(Fqn parentFqn) {
      List parentList=parentFqn.l;
      // If they have the same size or the parent node list is longer,
      // then parentFqn can't be the parent of this Fqn
      if( parentList.size() >= l.size() ) return false;
      for(int i=0; i < parentList.size(); i++) {
         if(!parentList.get(i).equals(l.get(i))) return false;
      }
      if(logger_.isDebugEnabled()) {
         logger_.debug("isChildOf(): fqn: " + l + " is a child of " + parentFqn);
      }
      return true;
   }

}
