package org.jboss.cache.interceptors;

import org.jboss.cache.*;
import org.jgroups.blocks.MethodCall;

import javax.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.List;

/**
 * Handles putXXX() methods: if the given node doesn't exist, it will be created
 * (depending on the create_if_not_exists argument)
 * @author Bela Ban
 * @version $Id: CreateIfNotExistsInterceptor.java,v 1.5.2.1 2004/12/30 17:08:24 starksm Exp $
 */
public class CreateIfNotExistsInterceptor extends Interceptor {
   TransactionManager tx_mgr=null;

   static final List putMethods=new ArrayList(3);

   static {
      putMethods.add(TreeCache.putDataEraseMethodLocal);
      putMethods.add(TreeCache.putDataMethodLocal);
      putMethods.add(TreeCache.putKeyValMethodLocal);
   }


   public void setCache(TreeCache cache) {
      super.setCache(cache);
      tx_mgr=cache.getTransactionManager();
   }

   public Object invoke(MethodCall m) throws Throwable {
      if(putMethods.contains(m.getMethod())) {
         Object[] args=m.getArgs();
         Fqn fqn=(Fqn)(args != null? args[1] : null);
         if(fqn == null) {
            throw new CacheException("failed extracting FQN from method " + m);
         }
         else {
            synchronized(this) { // only 1 thread can be here at any time - missing node needs to be created only once
               if(!cache.exists(fqn))
                  createNode(fqn, cache.getCurrentTransaction());
            }
         }
      }
      return super.invoke(m);
   }


   private void createNode(Fqn fqn, GlobalTransaction tx) {
      Node n, child_node=null;
      Object child_name;
      Fqn tmp_fqn=new Fqn(), copy;

      if(fqn == null) return;
      int treeNodeSize=fqn.size();
      n=cache.getRoot();
      for(int i=0; i < treeNodeSize; i++) {
         child_name=fqn.get(i);
         tmp_fqn=new Fqn(tmp_fqn, child_name);
         child_node=n.getChild(child_name);
         if(child_node == null) {
            copy=(Fqn)tmp_fqn.clone();
            child_node=n.createChild(child_name, copy, n);
            if(tx != null) {
               // add the node name to the list maintained for the current tx
               // (needed for abort/rollback of transaction)
               cache.addNode(tx, (Fqn)tmp_fqn.clone());
            }
            cache.notifyNodeCreated(copy);
         }
         n=child_node;
      }
   }


}
