package org.jboss.cache.loader;

import org.jboss.cache.Fqn;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

/**
 * Serializable representation of the data of a node (FQN and attributes)
 * @author Bela Ban
 * @version $Id: NodeData.java,v 1.1.2.2 2004/12/30 17:08:27 starksm Exp $
 */
public class NodeData implements Externalizable {
   Fqn     fqn=null;
   Map     attrs=null;

   public NodeData() {
   }

   public NodeData(Fqn fqn) {
      this.fqn=fqn;
   }

   public NodeData(Fqn fqn, Map attrs) {
      this.fqn=fqn;
      this.attrs=attrs;
   }

   public NodeData(String fqn, Map attrs) {
         this.fqn=Fqn.fromString(fqn);
         this.attrs=attrs;
      }


   public void writeExternal(ObjectOutput out) throws IOException {
      out.writeObject(fqn);
      if(attrs != null) {
         out.writeBoolean(true);
         out.writeObject(attrs);
      }
      else {
         out.writeBoolean(false);
      }
   }

   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
      fqn=(Fqn)in.readObject();
      if(in.readBoolean())
         attrs=(Map)in.readObject();
   }

   public String toString() {
      return "fqn: " + fqn + ", attrs=" + attrs;
   }

}
