/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;


/**
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a> Apr 10, 2003
 * @version $Revision: 1.1 $
 */
public class LockTest {
    static long TIMEOUT=1000;


    public static void main(String[] args) {

        Sync    lock;
        boolean rc;

        // lock=new FIFOSemaphore(1);
        // lock=new Mutex();
        lock=new ReentrantLock();


//        new Acquirer(lock, "number #1", 10).start(); // this will work
//        sleep(TIMEOUT);
//
//        new Acquirer(lock, "number #2", 10000).start();
//        sleep(TIMEOUT);
//
//        new Acquirer(lock, "number #3", 30000).start();
//        sleep(15000);
//
//        new Releaser(lock).start();
//        sleep(TIMEOUT);
//
//        new Releaser(lock).start();
//        sleep(TIMEOUT);
//
//        new Releaser(lock).start();
//        sleep(TIMEOUT);


        try {
            System.out.println("-- [" +  Thread.currentThread() + "]: getting lock");
            lock.acquire();
            System.out.println("-- [" +  Thread.currentThread() + "]: OK");


            System.out.println("-- [" +  Thread.currentThread() + "]: getting lock");
            lock.acquire();
            System.out.println("-- [" +  Thread.currentThread() + "]: OK");

            System.out.println("-- [" +  Thread.currentThread() + "]: getting lock");
            lock.acquire();
            System.out.println("-- [" +  Thread.currentThread() + "]: OK");


            System.out.println("-- [" +  Thread.currentThread() + "]: releasing lock");
            lock.release();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }

    }

    static void sleep(long timeout) {
        try {
            Thread.currentThread().sleep(timeout);
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class Acquirer extends Thread {
        Sync lock=null;
        long timeout;

        Acquirer(Sync lock, String name, long timeout) {
            this.lock=lock;
            this.timeout=timeout;
            setName(name);
        }

        public void run() {
            boolean rc;

            try {
                System.out.println("-- [" +  Thread.currentThread() + "]: getting lock");
                rc=lock.attempt(timeout);
                System.out.println("-- [" +  Thread.currentThread() + "]: acquired lock" +
                                   " result=" + (rc? "OK" : "FAIL"));
            }
            catch(InterruptedException e) {
                e.printStackTrace();
            }
        }
    }


    static class Releaser extends Thread {

        Sync lock=null;

        Releaser(Sync lock) {
            this.lock=lock;
        }

        public void run() {
            System.out.println("-- [" +  Thread.currentThread() + "]: releasing lock");
            lock.release();
        }
    }

}
