// $Id: SimpleEvictionPolicy.java,v 1.1 2003/10/30 01:21:19 bwang00 Exp $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache;


/**
 * Simple implementation of {@link EvictionPolicy}. Registers with Cache as
 * {@link CacheListener} and listens for cache changes. When the number of
 * cache entries exceeds {@link CacheImplMBean#getMaxCapacity()}, the oldest N
 * entries will be removed (each entry is tagged with a timestamp). We need to
 * make sure <em>not</em> to remove any items which are currently involved in a
 * transaction (ie. have a lock). When en entry is removed, and it is not
 * transient, it will be removed from all  caches in the cluster.<br/> Note that
 * since this class is in the same package as the CacheImpl, we can access
 * CacheImpl's package- private methods (e.g. {@link Cache#get(Object)}
 * and {@link Cache#keySet()}).
 * @author Bela Ban
 * @version $Revision: 1.1 $
 */
public class SimpleEvictionPolicy implements EvictionPolicy {
    CacheImpl cache=null;

    /**
     * Sets the initial cache. Called <em>before</em> any of the lifecycle
     * methods.
     * @see org.jboss.cache.EvictionPolicy#setCache(org.jboss.cache.CacheImpl)
     */
    public void setCache(CacheImpl c) {
        cache=c;
    }

    /**
     * We are being created. It is guaranteed that at this time <tt>cache</tt>
     * is not null.
     * @see org.jboss.system.Service#create()
     */
    public void create() throws Exception {
    }

    /**
     * Begin work. Called after cache has been started.
     * @see org.jboss.system.Service#start()
     */
    public void start() throws Exception {
    }

    /**
     * Stop work. Called before cache is stopped.
     * @see org.jboss.system.Service#stop()
     */
    public void stop() {
    }

    /**
     * We are being destroyed. Called after cache has been stopped, but before
     * cache is destroyed.
     * @see org.jboss.system.Service#destroy()
     */
    public void destroy() {
    }

}
