/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.ha.jndi;

import java.net.UnknownHostException;
import java.util.Map;
import javax.management.ObjectName;

import org.jboss.invocation.Invocation;

/** The standard mbean management interface for the DetachedHANamingService
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 *
 * <p><b>Revisions:</b><br>
 */
public interface DetachedHANamingServiceMBean
   extends org.jboss.system.ServiceMBean
{
   /** Get the name of the underlying partition for the cluster to use.
    */
   String getPartitionName();
   /** Set the name of the underlying partition for the cluster to use.
    */
   void setPartitionName(String partitionName);

   /** Get the proxy factory service name used to create the Naming transport
    * proxy.
    */ 
   public ObjectName getProxyFactoryObjectName();
   /** Set the proxy factory service name used to create the Naming transport
    * proxy.
    */ 
   public void setProxyFactoryObjectName(ObjectName proxyFactory);

   /** Get the bootstrap port on which the HA-JNDI stub is made available
    */
   int getPort();
   /** Set the bootstrap port on which the HA-JNDI stub is made available
    */
   void setPort(int p);

   /** Get the bootstrap IP address on which the HA-JNDI stub is made available
    */
   String getBindAddress();
   /** Set the bootstrap IP address on which the HA-JNDI stub is made available
    */
   void setBindAddress(String host) throws UnknownHostException;

   /** Get the accept backlog for the bootstrap server socket
    */
   int getBacklog();
   /** Set the accept backlog for the bootstrap server socket
    */
   void setBacklog(int backlog);

   /** Get the Auto-discovery multicast port
    */
   int getAutoDiscoveryGroup();
   /** Set the Auto-discovery multicast port.
    */
   void setAutoDiscoveryGroup(int adGroup);

   /** Get the auto-discovery bootstrap multicast address.
    */ 
   String getAutoDiscoveryAddress();
   /** Set the auto-discovery bootstrap multicast address. If null or empty, no
    * auto-discovery bootstrap socket will be created.
    */
   void setAutoDiscoveryAddress(String adAddress);

   /** Expose the Naming service interface mapping as a read-only attribute
    *
    * @jmx:managed-attribute
    *
    * @return A Map<Long hash, Method> of the Naming interface
    */
   public Map getMethodMap();

   /** Expose the Naming service via JMX for detached invokers.
    *
    * @param invocation    A pointer to the invocation object
    * @return              Return value of method invocation.
    *
    * @throws Exception    Failed to invoke method.
    */
   public Object invoke(Invocation invocation) throws Exception;
}
