/***************************************
*                                     *
*  JBoss: The OpenSource J2EE WebOS   *
*                                     *
*  Distributable under LGPL license.  *
*  See terms of license at gnu.org.   *
*                                     *
***************************************/

package org.jboss.ha.jndi;

import java.net.UnknownHostException;

import java.util.Map;



import javax.management.ObjectName;



import org.jboss.invocation.Invocation;

import org.jboss.mx.util.ObjectNameFactory;

/**

 * HA-JNDI service that provides JNDI services in a clustered way.
 * Bindings are replicated cluster-wide.
 * Lookups are:
 *    - first resolved locally in the cluster-wide tree
 *    - if not available, resolved in the local underlying JNDI tree
 *    - if not available, the query is broadcast on the cluster and each node determines
 *      if it has one in its local JNDI tree
 *
 * The HA-JNDI service also provides an automatic-discovery feature that allow clients
 * to resolve the service through multicast.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>
 * @version $Revision: 1.10.4.6 $
 *
 * <p><b>Revisions:</b><br>
 */
public interface HANamingServiceMBean
   extends DetachedHANamingServiceMBean
{
   /**
    * RmiPort to be used by the HA-JNDI service once bound. 0 => auto.
    */
   void setRmiPort(int p);
   int getRmiPort();

   /**
    * Client socket factory to be used for client-server RMI invocations during JNDI queries
    */
   String getClientSocketFactory();
   void setClientSocketFactory(String factoryClassName)
           throws ClassNotFoundException, InstantiationException, IllegalAccessException;
   /**
    * Server socket factory to be used for client-server RMI invocations during JNDI queries
    */
   String getServerSocketFactory();
   void setServerSocketFactory(String factoryClassName)
           throws ClassNotFoundException, InstantiationException, IllegalAccessException;

}
