/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.logging.appender;

import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;


/** 
 * An implementation of the log4j TriggeringEventEvaluator that triggers
 * in case of event level >= INFO.
 * 
 * The following JBoss SMTP appender definition shows an example for sending 
 * EMail notifications for INFO level log events within ..\conf\log4j.xml 
 * 
 *  <appender name="SMTP" class="org.apache.log4j.net.SMTPAppender">
 *    <errorHandler class="org.jboss.logging.util.OnlyOnceErrorHandler"/>
 *    <param name="Threshold" value="INFO"/>
 *    <param name="To" value="admin@myhost.domain.com"/>
 *    <param name="From" value="nobody@myhost.domain.com"/>
 *    <param name="Subject" value="JBoss Server Errors"/>
 *    <param name="SMTPHost" value="localhost"/>
 *    <param name="BufferSize" value="1"/>
 *    <layout class="org.apache.log4j.PatternLayout">
 *      <param name="ConversionPattern" value="[%d{ABSOLUTE},%c{1}] %m%n"/>
 *    </layout>
 *    <param name="EvaluatorClass"
 *           value="org.jboss.logging.appender.InfoLevelEventEvaluator" />
 * </appender>   
 * 
 * @author ulf.schroeter@mobilcom.de
 * @version $Revision: 1.1.2.1 $
 */
public class InfoLevelEventEvaluator implements TriggeringEventEvaluator
{
	/** Trigger event in case of event level >= INFO.
	 *
	 * @param event 	the logging event to check
	 * @return true 	event level >= INFO
	 */
	public boolean isTriggeringEvent(LoggingEvent event)
	{
		if (event.getLevel().toInt() >= Level.INFO_INT) return true;
		else 											return false;
	}
}

