/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.util.propertyeditor;

import java.beans.PropertyEditorSupport;

/** A property editor for {@link java.lang.Short}.
 *
 * @version $Revision: 1.1.4.1 $
 */
public class ShortEditor extends PropertyEditorSupport
{
   /** Map the argument text into and Short using Short.decode.
    */
   public void setAsText(final String text)
   {
      Object newValue = Short.decode(text);
      setValue(newValue);
   }

}
