/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.resource.adapter.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;

/**
 * A wrapper for a message
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public class JmsBytesMessage extends JmsMessage implements BytesMessage
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new wrapper
    * 
    * @param message the message
    * @param session the session
    */
   public JmsBytesMessage(BytesMessage message, JmsSession session)
   {
      super(message, session);
   }
   
   // Public --------------------------------------------------------
   
   // BytesMessage implementation -----------------------------------
   
   public boolean readBoolean() throws JMSException
   {
      return ((BytesMessage) message).readBoolean();
   }
   
   public byte readByte() throws JMSException
   {
      return ((BytesMessage) message).readByte();
   }
   
   public int readBytes(byte[] value, int length) throws JMSException
   {
      return ((BytesMessage) message).readBytes(value, length);
   }
   
   public int readBytes(byte[] value) throws JMSException
   {
      return ((BytesMessage) message).readBytes(value);
   }
   
   public char readChar() throws JMSException
   {
      return ((BytesMessage) message).readChar();
   }
   
   public double readDouble() throws JMSException
   {
      return ((BytesMessage) message).readDouble();
   }
   
   public float readFloat() throws JMSException
   {
      return ((BytesMessage) message).readFloat();
   }
   
   public int readInt() throws JMSException
   {
      return ((BytesMessage) message).readInt();
   }
   
   public long readLong() throws JMSException
   {
      return ((BytesMessage) message).readLong();
   }
   
   public short readShort() throws JMSException
   {
      return ((BytesMessage) message).readShort();
   }
   
   public int readUnsignedByte() throws JMSException
   {
      return ((BytesMessage) message).readUnsignedByte();
   }
   
   public int readUnsignedShort() throws JMSException
   {
      return ((BytesMessage) message).readUnsignedShort();
   }
   
   public String readUTF() throws JMSException
   {
      return ((BytesMessage) message).readUTF();
   }
   
   public void reset() throws JMSException
   {
      ((BytesMessage) message).reset();
   }
   
   public void writeBoolean(boolean value) throws JMSException
   {
      ((BytesMessage) message).writeBoolean(value);
   }
   
   public void writeByte(byte value) throws JMSException
   {
      ((BytesMessage) message).writeByte(value);
   }
   
   public void writeBytes(byte[] value, int offset, int length) throws JMSException
   {
      ((BytesMessage) message).writeBytes(value, offset, length);
   }
   
   public void writeBytes(byte[] value) throws JMSException
   {
      ((BytesMessage) message).writeBytes(value);
   }
   
   public void writeChar(char value) throws JMSException
   {
      ((BytesMessage) message).writeChar(value);
   }
   
   public void writeDouble(double value) throws JMSException
   {
      ((BytesMessage) message).writeDouble(value);
   }
   
   public void writeFloat(float value) throws JMSException
   {
      ((BytesMessage) message).writeFloat(value);
   }
   
   public void writeInt(int value) throws JMSException
   {
      ((BytesMessage) message).writeInt(value);
   }
   
   public void writeLong(long value) throws JMSException
   {
      ((BytesMessage) message).writeLong(value);
   }

   public void writeObject(Object value) throws JMSException
   {
      ((BytesMessage) message).writeObject(value);
   }

   public void writeShort(short value) throws JMSException
   {
      ((BytesMessage) message).writeShort(value);
   }

   public void writeUTF(String value) throws JMSException
   {
      ((BytesMessage) message).writeUTF(value);
   }
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
