/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.resource.adapter.jms;

import java.io.Serializable;

import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;

/**
 * An aggregate interface for QueueConnectionFactory and
 * TopicConnectionFactory.  Also marks as serializable.
 *
 * <p>Created: Thu Apr 26 17:01:35 2001
 *
 * @author  <a href="mailto:peter.antman@tim.se">Peter Antman</a>.
 * @version <pre>$Revision: 1.2.2.1 $</pre>
 */
public interface JmsConnectionFactory 
   extends ConnectionFactory,
           TopicConnectionFactory,
           QueueConnectionFactory,
           Serializable
{
   int BOTH = 0;
   int QUEUE = 1;
   int TOPIC = 2;
}
