/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.resource.adapter.jms;

import java.util.Enumeration;
import java.util.Vector;

import javax.jms.ConnectionMetaData;

/**
 * This class implements javax.jms.ConnectionMetaData
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Norbert.Lataille@m4x.org)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public class JmsConnectionMetaData implements ConnectionMetaData
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   
   // ConnectionMetaData implementation -----------------------------
   
   public String getJMSVersion()
   {
      return "1.0";
   }

   public int getJMSMajorVersion()
   {
      return 1;
   }

   public int getJMSMinorVersion()
   {
      return 0;
   }

   public String getJMSProviderName()
   {
      return "JBoss";
   }

   public String getProviderVersion()
   {
      return "3.2";
   }

   public int getProviderMajorVersion()
   {
      return 3;
   }

   public int getProviderMinorVersion()
   {
      return 2;
   }

   public Enumeration getJMSXPropertyNames()
   {
      Vector vector = new Vector();
      vector.add("JMSXGroupID");
      vector.add("JMSXGroupSeq");
      return vector.elements();
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
