/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.resource.adapter.jms;

import javax.resource.spi.ConnectionRequestInfo;

import javax.jms.Session;

import org.jboss.util.Strings;

/**
 * Request information used in pooling
 *
 * Created: Thu Mar 29 16:29:55 2001
 *
 * @author <a href="mailto:peter.antman@tim.se">Peter Antman</a>.
 * @version $Revision: 1.2.2.1 $
 */
public class JmsConnectionRequestInfo
   implements ConnectionRequestInfo
{
   private String userName;
   private String password;
   private String clientID;

   private boolean transacted = true;
   private int acknowledgeMode = Session.AUTO_ACKNOWLEDGE;
   private int type = JmsConnectionFactory.BOTH;

   /**
    * Creats with the MCF configured properties.
    */
   public JmsConnectionRequestInfo(JmsMCFProperties prop)
   {
      this.userName = prop.getUserName();
      this.password = prop.getPassword();
      this.clientID = prop.getClientID();
      this.type = prop.getType();
   }

   /**
    * Create with specified properties.
    */
   public JmsConnectionRequestInfo(final boolean transacted, 
				   final int acknowledgeMode,
				   final int type)
   {
      this.transacted = transacted;
      this.acknowledgeMode = acknowledgeMode;
      this.type = type;
   }
   
   /**
    * Fill in default values if missing. Only applies to user and password.
    */
   public void setDefaults(JmsMCFProperties prop)
   {
      if (userName == null)
         userName = prop.getUserName();//May be null there to
      if (password == null) 
         password = prop.getPassword();//May be null there to
      if (clientID == null) 
         clientID = prop.getClientID();//May be null there to
   }

   public String getUserName() 
   {
      return userName;
   }
    
   public void setUserName(String name) 
   {
      userName = name;
   }

   public String getPassword() 
   {
      return password;
   }

   public void setPassword(String password) 
   {
      this.password = password;
   }

   public String getClientID() 
   {
      return clientID;
   }

   public void setClientID(String clientID) 
   {
      this.clientID = clientID;
   }

   public boolean isTransacted()
   {
      return transacted;
   }
    
   public int getAcknowledgeMode()
   {
      return acknowledgeMode;
   }

   public int getType()
   {
      return type;
   }

   public boolean equals(Object obj)
   {
      if (obj == null) return false;
      if (obj instanceof JmsConnectionRequestInfo)
      {
         JmsConnectionRequestInfo you = (JmsConnectionRequestInfo) obj;
         return (this.transacted == you.isTransacted() &&
            this.acknowledgeMode == you.getAcknowledgeMode() &&
            this.type == you.getType() &&
            Strings.compare(userName, you.getUserName()) &&
            Strings.compare(password, you.getPassword()) &&
            Strings.compare(clientID, you.getClientID()));
      }
      else
         return false;
   }
 
   public int hashCode()
   {
      int hashCode = 0;
      if (transacted)
         hashCode += 1;
      if (type == JmsConnectionFactory.QUEUE)
         hashCode += 3;
      else if (type == JmsConnectionFactory.TOPIC)
         hashCode += 5;
      if (acknowledgeMode == Session.AUTO_ACKNOWLEDGE)
         hashCode += 7;
      else if (acknowledgeMode == Session.DUPS_OK_ACKNOWLEDGE)
         hashCode += 11;
      if (userName != null)
         hashCode += userName.hashCode();
      if (password != null)
         hashCode += password.hashCode();
      if (clientID != null)
         hashCode += clientID.hashCode();
      
      return hashCode;
   }
    
   /**
    * May be used if we fill in username and password later.
    */
   private boolean isEqual(Object o1, Object o2)
   {
      if (o1 == null)
         return (o2 == null);
      else
         return o1.equals(o2);
   }
}
