/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.resource.adapter.jms;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

/**
 * A wrapper for a queue receiver
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public class JmsQueueReceiver extends JmsMessageConsumer implements QueueReceiver
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new wrapper
    * 
    * @param consumer the queue receiver
    * @param session the session
    */
   public JmsQueueReceiver(QueueReceiver consumer, JmsSession session)
   {
      super(consumer, session);
   }
   
   // Public --------------------------------------------------------
   
   // QueueReceiver implementation ----------------------------------

   public Queue getQueue() throws JMSException
   {
      return ((QueueReceiver) consumer).getQueue();
   }
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
