/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.resource.adapter.jms;

import javax.jms.JMSException;
import javax.jms.TextMessage;

/**
 * A wrapper for a message
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public class JmsTextMessage extends JmsMessage implements TextMessage
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new wrapper
    * 
    * @param message the message
    * @param session the session
    */
   public JmsTextMessage(TextMessage message, JmsSession session)
   {
      super(message, session);
   }
   
   // Public --------------------------------------------------------
   
   // TextMessage implementation ------------------------------------

   public String getText() throws JMSException
   {
      return ((TextMessage) message).getText();
   }
   
   public void setText(String string) throws JMSException
   {
      ((TextMessage) message).setText(string);
   }
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
