/*
 *
 */
package org.jboss.console.plugins.helpers.servlet;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 *
 */
public class TabTag extends TagSupport
{		
	private String name;
	private String href;
	private boolean selected;
	
	private NavigationTag myParent = null;
	
	public int doStartTag() throws JspTagException
	{
		myParent = (NavigationTag)findAncestorWithClass(this, NavigationTag.class);
		if (myParent == null) 
		{
			throw new JspTagException("Tab tag not nested within navigation tag.");
		}		
		
		if (name != null)
		{
			addToParent();			
		}
		return EVAL_BODY_INCLUDE;
	}

	/**
	 * 
	 */
	private void addToParent()
	{
		Tab tab = new Tab(name, href, selected);
		myParent.setTabs(tab);
	}
	/**
	 * @return
	 */
	public String getHref()
	{
		return href;
	}

	/**
	 * @return
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * @return
	 */
	public boolean isSelected()
	{
		return selected;
	}

	/**
	 * @param string
	 */
	public void setHref(String string)
	{
		href = string;
	}

	/**
	 * @param string
	 */
	public void setName(String string)
	{
		name = string;
	}

	/**
	 * @param b
	 */
	public void setSelected(boolean b)
	{
		selected = b;
	}

}
