package org.jboss.console.plugins.monitor;

import org.jboss.monitor.ThresholdMonitor;
import org.jboss.monitor.SnapshotRecordingMonitor;
import org.jboss.mx.util.MBeanServerLocator;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: wburke
 * Date: Nov 25, 2003
 * Time: 5:53:01 PM
 * To change this template use Options | File Templates.
 */
public class CreateSnapshotServlet extends javax.servlet.http.HttpServlet
{
   protected void doGet(HttpServletRequest req, HttpServletResponse resp)
           throws ServletException, IOException
   {
      doit(req, resp);
   }

   protected void doPost(HttpServletRequest req, HttpServletResponse resp)
           throws ServletException, IOException
   {
      doit(req, resp);
   }

   protected void error(String msg, HttpServletRequest req, HttpServletResponse resp)
           throws ServletException, IOException
   {
      req.setAttribute("error", "Error: " + msg);
      //this.getServletContext().getRequestDispatcher("/createThresholdMonitor.jsp").forward(req, resp);
      req.getRequestDispatcher("/createSnapshot.jsp").forward(req, resp);
      return;
   }

   protected void doit(HttpServletRequest req, HttpServletResponse resp)
           throws ServletException, IOException
   {

      String monitorName = req.getParameter("monitorName").trim();
      //System.out.println(monitorName);
      String objectName = req.getParameter("objectName").trim();
      //System.out.println(objectName);
      MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
      ObjectName oname = null;
      try
      {
         oname = new ObjectName(objectName);
      }
      catch (MalformedObjectNameException e)
      {
         error("Malformed ObjectName ", req, resp);
         return;
      }
      String attribute = req.getParameter("attribute").trim();
      //System.out.println(attribute);
      Object val = null;
      try
      {
         val = mbeanServer.getAttribute(oname, attribute);
      }
      catch (Exception e)
      {
         error("Unable to pull attribute value from MBean, does the attribute exist? ", req, resp);
         return;
      }
      String period = req.getParameter("period").trim();
      //System.out.println(period);
      long timePeriod = 0;
      try
      {
         timePeriod = Long.parseLong(period);
      }
      catch (NumberFormatException e)
      {
         error("Illegal format for watch period.", req, resp);
         return;
      }
      try
      {
         SnapshotRecordingMonitor monitor = new SnapshotRecordingMonitor();

         monitor.setMonitorName(monitorName);
         monitor.setObservedObject(oname);
         monitor.setObservedAttribute(attribute);
         monitor.setPeriod(timePeriod);
         ObjectName sname = new ObjectName("jboss.snapshot:name=" + monitorName);
         mbeanServer.registerMBean(monitor, sname);
         resp.sendRedirect("/web-console/manageSnapshot.jsp?monitorObjectName=" + java.net.URLEncoder.encode(sname.toString()));
      }
      catch (Exception ex)
      {
         error("Failed to create non-persisted monitor: " + ex.toString(), req, resp);
      }


   }

}
