/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.iiop;

/**
 * There is a bug in Sun's implementation of the method javax.rmi.CORBA.Util.isLocal().
 * Stubs generated with the rmic tool call this method to check is the call is a local invocation,
 * which they can optimize. However, Sun's implementation of isLocal() tries to cast the stub to a proprietary
 * class. This is against the rules. Since the ORB is pluggable ("-Dorg.omg.CORBA.ORBClass=...), Sun's
 * implementation of a standard (javax.rmi) method should not assume that the stubs are Sun stubs.
 *
 * @author <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 * @version $Revision: 1.1.8.1 $
 *
 **/
public class SunJDK14IsLocalBugFix extends com.sun.corba.se.internal.iiop.ShutdownUtilDelegate
{
   public boolean isLocal(javax.rmi.CORBA.Stub stub)
           throws java.rmi.RemoteException
   {
      try
      {
         org.omg.CORBA.portable.Delegate delegate = stub._get_delegate();
         return delegate.is_local(stub);
      }
      catch (org.omg.CORBA.SystemException e)
      {
         throw javax.rmi.CORBA.Util.mapSystemException(e);
      }
   }
}
