/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.iiop.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jnp.interfaces.NamingContextFactory;
import org.omg.CORBA.ORB;

/**
 * An ORBInitialContextFactory, that includes the orb
 * in the environment.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.6.1 $
 */
public class ORBInitialContextFactory extends NamingContextFactory
{
   public static final String ORB_INSTANCE = "java.naming.corba.orb";
   
   /** The orb to include in the naming environment */
   private static ORB orb;
   
   /**
    * Set the orb
    * 
    * @param orb the orb to use
    */
   public static void setORB(ORB orb)
   {
      ORBInitialContextFactory.orb = orb;
   }

   public Context getInitialContext(Hashtable env) throws NamingException
   {
      insertORB(env);
      return super.getInitialContext(env);
   }
   
   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception
   {
      insertORB(environment);
      return super.getObjectInstance(obj, name, nameCtx, environment);
   }
   
   protected void insertORB(Hashtable environment)
   {
      if (orb != null && environment.containsKey(ORB_INSTANCE) == false)
         environment.put(ORB_INSTANCE, orb);
   }
}
