/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.axis.encoding;

import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.SAXException;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


// Target is set via a method call.  The set method places the value in the field.

public class MethodTarget implements Target
{
   private static Logger log = Logger.getLogger(MethodTarget.class.getName());

   private Object targetObject;
   private Method targetMethod;
   private static final Class[] objArg = new Class[]{Object.class};

   /**
    * Construct a target whose value is set via a method
    *
    * @param targetObject is the object containing the value to be set
    * @param targetMethod is the Method used to set the value
    */
   public MethodTarget(Object targetObject, Method targetMethod)
   {
      this.targetObject = targetObject;
      this.targetMethod = targetMethod;
   }

   /**
    * Construct a target whose value is set via a method
    *
    * @param targetObject is the object containing the value to be set
    * @param methodName   is the name of the Method
    */
   public MethodTarget(Object targetObject, String methodName)
           throws NoSuchMethodException
   {
      this.targetObject = targetObject;
      Class cls = targetObject.getClass();
      targetMethod = cls.getMethod(methodName, objArg);
   }

   /**
    * Set the target's value by invoking the targetMethod.
    *
    * @param value is the new Object value
    */
   public void set(Object value) throws SAXException
   {
      try
      {
         targetMethod.invoke(targetObject, new Object[]{value});
      }
      catch (IllegalAccessException accEx)
      {
         log.error(Messages.getMessage("illegalAccessException00"),
                 accEx);
         throw new SAXException(accEx);
      }
      catch (IllegalArgumentException argEx)
      {
         log.error(Messages.getMessage("illegalArgumentException00"),
                 argEx);
         throw new SAXException(argEx);
      }
      catch (InvocationTargetException targetEx)
      {
         log.error(Messages.getMessage("invocationTargetException00"),
                 targetEx);
         throw new SAXException(targetEx);
      }
   }
}
