/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.axis.message;

import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

/**
 * A simple header element abstraction.  Extends MessageElement with
 * header-specific stuff like mustUnderstand, actor, and a 'processed' flag.
 *
 * @author Glen Daniels (gdaniels@macromedia.com)
 * @author Glyn Normington (glyn@apache.org)
 */
public class SOAPHeaderElementAxisImpl extends SOAPHeaderElementImpl
{
   protected boolean processed;

   public SOAPHeaderElementAxisImpl(String namespace, String localPart)
   {
      super(namespace, localPart);
   }

   public SOAPHeaderElementAxisImpl(Name name)
   {
      super(name);
   }

   public SOAPHeaderElementAxisImpl(String namespace, String localPart, Object value)
   {
      super(namespace, localPart, value);
   }

   public SOAPHeaderElementAxisImpl(Element elem)
   {
      super(elem);
   }

   public SOAPHeaderElementAxisImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context)
           throws AxisFault
   {
      super(namespace, localPart, prefix, attributes, context);
   }

   public void setParentElement(SOAPElement parent) throws SOAPException
   {
      if (parent == null)
         throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
      if (!(parent instanceof SOAPHeaderAxisImpl))
         throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
      try
      {
         super.setParentElement(parent);
      }
      catch (Throwable t)
      {
         throw new SOAPException(t);
      }
   }

   /** Check for env:mustUnderstand
    */
   public boolean getMustUnderstand()
   {
      String envURI = Constants.URI_SOAP11_ENV;
      String val = getAttributeNS(envURI, Constants.ATTR_MUST_UNDERSTAND);
      return "1".equals(val);
   }

   public void setMustUnderstand(boolean mustUnderstand)
   {
      String envURI = Constants.URI_SOAP11_ENV;
      String prefix = Constants.NS_PREFIX_SOAP_ENV;
      String val = mustUnderstand ? "1" : "0";
      setAttributeNS(envURI, prefix + ":" + Constants.ATTR_MUST_UNDERSTAND, val);
   }

   public String getActor()
   {
      String envURI = Constants.URI_SOAP11_ENV;
      String actor = getAttributeNS(envURI, Constants.ATTR_ACTOR);
      return actor;
   }

   public void setActor(String actor)
   {
      String envURI = Constants.URI_SOAP11_ENV;
      String prefix = Constants.NS_PREFIX_SOAP_ENV;
      setAttributeNS(envURI, prefix + ":" + Constants.ATTR_ACTOR, actor);
   }

   public String getRole()
   {
      return getActor();
   }

   public void setRole(String role)
   {
      setActor(role);
   }

   public void setProcessed(boolean value)
   {
      processed = value;
   }

   public boolean isProcessed()
   {
      return (processed);
   }
}
