/*
 * Copyright 2002-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.axis.message;

import org.apache.axis.AxisFault;
import org.apache.axis.NotImplementedException;
import org.apache.axis.encoding.DeserializationContext;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import java.util.Iterator;


/**
 * An implemenation of the abstract SOAPEnvelope.
 * <p/>
 * This class should not expose functionality that is not part of
 * {@link javax.xml.soap.SOAPHeader}. Client code should use <code>SOAPHeader</code> if possible.
 *
 * @author Thomas Diesler (thomas.diesler@jboss.org)
 */
public class SOAPHeaderImpl extends SOAPElementAxisImpl implements SOAPHeader
{

   private static Logger log = Logger.getLogger(SOAPHeaderImpl.class.getName());

   SOAPHeaderImpl(String localPart, String prefix, String namespace)
   {
      super(localPart, prefix, namespace);
   }

   SOAPHeaderImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault
   {
      super(namespace, localPart, prefix, attributes, context);
   }

   public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException
   {
      throw new NotImplementedException();
   }

   public Iterator examineAllHeaderElements()
   {
      throw new NotImplementedException();
   }

   public Iterator examineHeaderElements(String actor)
   {
      throw new NotImplementedException();
   }

   public Iterator examineMustUnderstandHeaderElements(String actor)
   {
      throw new NotImplementedException();
   }

   public Iterator extractAllHeaderElements()
   {
      throw new NotImplementedException();
   }

   public Iterator extractHeaderElements(String actor)
   {
      throw new NotImplementedException();
   }
}
