/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 * Created on Feb 5, 2004
 */
package org.jboss.net.axis.security;

import javax.xml.namespace.QName;

import org.apache.ws.security.WSConstants;

/**
 * <dl>
 * <dt><b>Title: </b><dd>Security Constants</dd>
 * <p>
 * <dt><b>Description: </b><dd>Constants used by the WSSecurity handlers</dd>
 * <p>
 * </dl>
 * @author <a href="mailto:jasone@greenrivercomputing.com">Jason Essington</a>
 * @version $Revision: 1.1.6.1 $
 */
public interface SecurityConstants
{
   /** Configuration prameter for the {@link org.jboss.net.axis.security.handler.WSSRequestHandler} and 
    * {@link org.jboss.net.axis.security.handler.WSSResponseHandler} used to define the jndi name of the
    * {@link org.jboss.security.SecurityDomain} that will be serving the handlers.*/
   public static final String HANDLER_SEC_DOMAIN = "securityDomain";

   /**
    * Configuration prameter for the {@link org.jboss.net.axis.security.handler.WSSRequestHandler} and 
    * {@link org.jboss.net.axis.security.handler.WSSResponseHandler} used to define the 
    * {@link org.jboss.net.axis.security.JBossCrypto} implementation that should be used by the handlers.
    */
   public static final String HANDLER_CRYPTO_CLASS = "cryptoImplementation";

   public static final QName SECURITY_HEADER_QNAME = new QName(WSConstants.WSSE_NS, WSConstants.WSSE_LN);

   /** 
    * Map of Keystore aliases that were used to sign the incoming request. 
    * The map key is the actor/role and the value is the Keystore alias of the certificate used to sign.
    */
   public static final String MC_REQ_SIGNERS = "security.request.signers";
}
