/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.net.axis.server;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.axis.transport.http.AxisServlet;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.MessageContext;
import org.apache.axis.server.AxisServer;

/**
 * <p>
 * An AxisServlet that is able to extract the corresponding AxisEngine 
 * from its installation context and builds the right message contexts for the
 * JBoss classloading and deployment architecture.
 * </p>
 * <p>
 * This servlet will also reconstruct proper SOAPAction for http-get accesses
 * in order not to rely on unsecure url-mapping
 * </p>
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @created 7. September 2001, 19:17
 * @version $Revision: 1.2.4.5 $
 */

public class AxisServiceServlet extends AxisServlet
{

   /** reference to the server */
   protected AxisServer server = null;

   /** Creates new AxisServlet */
   public AxisServiceServlet()
   {
   }

   /** 
    * override AxisServlet.getEngine() in order to redirect to
    * the corresponding AxisEngine.
    */
   public org.apache.axis.server.AxisServer getEngine() throws AxisFault
   {
      if (server == null)
      {
         // we need to extract the engine from the 
         // rootcontext
         String installation =
            getConfigurationContext();
         // call the static service method to find the installed engine
         try
         {
            server =
               JMXEngineConfigurationFactory
               .newJMXFactory(installation)
               .getAxisServer();
         }
         catch (NullPointerException e)
         {
            throw new AxisFault(
               "Could not access JMX configuration factory.",
               e);
         }
      }

      return server;
   }

   /** access configuration context */
   protected String getConfigurationContext()
   {
      return getInitParameter(
         org.jboss.net.axis.Constants.CONFIGURATION_CONTEXT);
   }

   /* (non-Javadoc)
    * a list request comes through get and 
    * does not need a particularly specified messagecontext
    * except to hook classloading information on. 
    * @see org.apache.axis.transport.http.AxisServlet#reportAvailableServices(javax.servlet.http.HttpServletResponse, java.io.PrintWriter, javax.servlet.http.HttpServletRequest)
    */
   protected void reportAvailableServices(
      HttpServletResponse arg0,
      PrintWriter arg1,
      HttpServletRequest arg2)
      throws ConfigurationException, AxisFault
   {
      MessageContext fake = new MessageContext(getEngine());
      AxisServer.setCurrentMessageContext(fake);
      super.reportAvailableServices(arg0, arg1, arg2);
   }

   /* (non-Javadoc)
    * through get, we will not be presented with a correct soapaction,
    * hence we fake it to the context path (see AxisServlet.getSoapAction())
    * @see org.apache.axis.transport.http.AxisServlet#processMethodRequest(org.apache.axis.MessageContext, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, java.io.PrintWriter)
    */
//   protected void processMethodRequest(
//      MessageContext arg0,
//      HttpServletRequest arg1,
//      HttpServletResponse arg2,
//      PrintWriter arg3)
//      throws AxisFault
//   {
//      fakeSoapAction(arg0);
//      super.processMethodRequest(arg0, arg1, arg2, arg3);
//   }

   /* (non-Javadoc)
    * through get, we will not be presented with a correct soapaction,
    * hence we fake it to the context path (see AxisServlet.getSoapAction())
    * @see org.apache.axis.transport.http.AxisServlet#processWsdlRequest(org.apache.axis.MessageContext, javax.servlet.http.HttpServletResponse, java.io.PrintWriter)
    */
//   protected void processWsdlRequest(
//      MessageContext arg0,
//      HttpServletResponse arg1,
//      PrintWriter arg2)
//      throws AxisFault
//   {
//      fakeSoapAction(arg0);
//      super.processWsdlRequest(arg0, arg1, arg2);
//   }
   
   /** set soap action uri to the path info */
   protected void fakeSoapAction(MessageContext arg0)
   {
      String pathInfo = (String) arg0.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);
      if (pathInfo == null)
      {
         pathInfo = "";
      }
      else if (pathInfo.startsWith("/"))
      {
         pathInfo = pathInfo.substring(1);
      }
      arg0.setSOAPActionURI(pathInfo);
   }

}