/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 * Created on Jul 2, 2004
 */
package org.jboss.net.axis.transport.mailto;

import java.io.InputStream;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

/**
 * <dl>
 * <dt><b>Title: </b><dd>JBoss.Net Email Message</dd>
 * <p>
 * <dt><b>Description: </b><dd>This is a MimeMessage that allows a mesage ID to be manually by the sender.</dd>
 * <p>
 * </dl>
 * @author <a href="mailto:jasone@greenrivercomputing.com">Jason Essington</a>
 * @version $Revision: 1.1.4.1 $
 */
public class MailMessage extends MimeMessage
{
   protected String messageID;

   /**
    * @param arg0
    * @throws javax.mail.MessagingException
    */
   public MailMessage(MimeMessage arg0) throws MessagingException
   {
      super(arg0);
      // TODO Auto-generated constructor stub
   }
   /**
    * @param arg0
    */
   public MailMessage(Session arg0)
   {
      super(arg0);
      // TODO Auto-generated constructor stub
   }
   /**
    * @param arg0
    * @param arg1
    * @throws javax.mail.MessagingException
    */
   public MailMessage(Session arg0, InputStream arg1) throws MessagingException
   {
      super(arg0, arg1);
      // TODO Auto-generated constructor stub
   }

   /**
    * If we have set our own messageID, we should use that other wise go ahead and use the one generated by javamail.
    * @see javax.mail.internet.MimeMessage#updateHeaders()
    */
   protected void updateHeaders() throws MessagingException
   {
      super.updateHeaders();
      if (messageID != null)
         setHeader("Message-ID", messageID);
   }

   /**
    * Returns the current message ID.
    */
   public String getMessageID()
   {
      return this.messageID;
   }

   /**
    * Set the message ID for this message.
    * @param id
    */
   public void setMessageID(String id)
   {
      this.messageID = id;
   }
}