/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: MBeanAttributeInfoDeser.java,v 1.4.6.1 2004/08/08 21:28:04 tdiesler Exp $

package org.jboss.net.jmx.adaptor;

import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;
import org.xml.sax.SAXException;
import org.xml.sax.Attributes;

import javax.xml.namespace.QName;
import javax.management.MBeanAttributeInfo;

/**
 * An <code>MBeanAttributeInfoDeser</code> is be used to deserialize
 * MBeanAttributeInfo using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision: 1.4.6.1 $
 */
public class MBeanAttributeInfoDeser extends DeserializerImpl
{

   private String name;
   private String type;
   private String description;
   private boolean isReadable;
   private boolean isWritable;
   private boolean isIs;

   public void onStartElement(
      String namespace,
      String localName,
      String prefix,
      Attributes attributes,
      DeserializationContext context)
      throws SAXException
   {

      if (context.isNil(attributes))
      {
         return;
      }

      //nothing to do

   }

   public SOAPHandler onStartChild(
      String namespace,
      String localName,
      String prefix,
      Attributes attributes,
      DeserializationContext context)
      throws SAXException
   {

      // Get the type
      QName itemType =
         context.getTypeFromAttributes(namespace, localName, attributes);
      // Get the deserializer
      Deserializer dSer = null;
      if (itemType != null)
      {
         dSer = context.getDeserializerForType(itemType);
      }
      if (dSer == null)
      {
         dSer = new DeserializerImpl();
      }

      // When the value is deserialized, inform us.
      // Need to pass the localName as a hint
      dSer.registerValueTarget(new DeserializerTarget(this, localName));

      addChildDeserializer(dSer);

      return (SOAPHandler) dSer;
   }

   public void setChildValue(Object value, Object hint) throws SAXException
   {
      if (hint.equals("name"))
         name = (String) value;
      else if (hint.equals("type"))
         type = (String) value;
      else if (hint.equals("description"))
         description = (String) value;
      else if (hint.equals("isReadable"))
         isReadable = ((Boolean) value).booleanValue();
      else if (hint.equals("isWritable"))
         isWritable = ((Boolean) value).booleanValue();
      else if (hint.equals("isIs"))
         isIs = ((Boolean) value).booleanValue();

   }

   public void onEndElement(
      String s,
      String s1,
      DeserializationContext deserializationcontext)
   {
      try
      {
         super.value =
            new MBeanAttributeInfo(
               name,
               type,
               description,
               isReadable,
               isWritable,
               isIs);
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
      }
   }

}
