/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: MBeanInfoDeser.java,v 1.5.4.1 2004/08/08 21:28:04 tdiesler Exp $

package org.jboss.net.jmx.adaptor;

import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;

import org.xml.sax.SAXException;
import org.xml.sax.Attributes;

import javax.xml.namespace.QName;
import javax.management.*;

/**
 * An <code>MBeanInfoDeser</code> is be used to deserialize
 * MBeanInfo using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision: 1.5.4.1 $
 */
public class MBeanInfoDeser extends DeserializerImpl
{

   private String className;
   private String description;
   private MBeanAttributeInfo[] attributes;
   private MBeanConstructorInfo[] constructors;
   private MBeanOperationInfo[] operations;
   private MBeanNotificationInfo[] notifications;

   public void onStartElement(
      String namespace,
      String localName,
      String prefix,
      Attributes attributes,
      DeserializationContext context)
      throws SAXException
   {

      if (context.isNil(attributes))
      {
         return;
      }

      //nothing to do

   }

   public SOAPHandler onStartChild(
      String namespace,
      String localName,
      String prefix,
      Attributes attributes,
      DeserializationContext context)
      throws SAXException
   {

      // Get the type
      QName itemType =
         context.getTypeFromAttributes(namespace, localName, attributes);
      // Get the deserializer
      Deserializer dSer = null;
      if (itemType != null)
      {
         dSer = context.getDeserializerForType(itemType);
      }
      if (dSer == null)
      {
         dSer = new DeserializerImpl();
      }

      // When the value is deserialized, inform us.
      // Need to pass the localName as a hint
      dSer.registerValueTarget(new DeserializerTarget(this, localName));

      addChildDeserializer(dSer);

      return (SOAPHandler) dSer;
   }

   public void setChildValue(Object value, Object hint) throws SAXException
   {
      if (hint.equals("className"))
         className = (String) value;
      else if (hint.equals("description"))
         description = (String) value;
      else if (hint.equals("attributes"))
         attributes = (MBeanAttributeInfo[]) value;
      else if (hint.equals("constructors"))
         constructors = (MBeanConstructorInfo[]) value;
      else if (hint.equals("operations"))
         operations = (MBeanOperationInfo[]) value;
      else if (hint.equals("notifications"))
         notifications = (MBeanNotificationInfo[]) value;

   }

   public void onEndElement(
      String s,
      String s1,
      DeserializationContext deserializationcontext)
   {
      try
      {
         super.value =
            new MBeanInfo(
               className,
               description,
               attributes,
               constructors,
               operations,
               notifications);
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
      }
   }

}
