/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: ObjectInstanceDeser.java,v 1.4.6.1 2004/08/08 21:28:04 tdiesler Exp $

package org.jboss.net.jmx.adaptor;

import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;
import org.xml.sax.SAXException;
import org.xml.sax.Attributes;

import javax.xml.namespace.QName;
import javax.management.ObjectName;
import javax.management.ObjectInstance;

/**
 * An <code>ObjectInstanceDeser</code> is be used to deserialize
 * ObjectInstance using the <code>SOAP-ENC</code>
 * encoding style.<p>
 *
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision: 1.4.6.1 $
 */
public class ObjectInstanceDeser extends DeserializerImpl
{

   ObjectName objectName;
   String className;

   public void onStartElement(
      String namespace,
      String localName,
      String prefix,
      Attributes attributes,
      DeserializationContext context)
      throws SAXException
   {

      if (context.isNil(attributes))
      {
         return;
      }

      //nothing to do

   }

   public SOAPHandler onStartChild(
      String namespace,
      String localName,
      String prefix,
      Attributes attributes,
      DeserializationContext context)
      throws SAXException
   {

      // Get the type
      QName itemType =
         context.getTypeFromAttributes(namespace, localName, attributes);
      // Get the deserializer
      Deserializer dSer = null;
      if (itemType != null)
      {
         dSer = context.getDeserializerForType(itemType);
      }
      if (dSer == null)
      {
         dSer = new DeserializerImpl();
      }

      // When the value is deserialized, inform us.
      // Need to pass the localName as a hint
      dSer.registerValueTarget(new DeserializerTarget(this, localName));

      addChildDeserializer(dSer);

      return (SOAPHandler) dSer;
   }

   public void setChildValue(Object value, Object hint) throws SAXException
   {
      if (hint.equals("className"))
         className = (String) value;
      else if (hint.equals("objectName"))
         objectName = (ObjectName) value;

   }

   public void onEndElement(
      String s,
      String s1,
      DeserializationContext deserializationcontext)
   {
      try
      {
         super.value = new ObjectInstance(objectName, className);
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
      }
   }

}
