/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting;

import org.jboss.remoting.network.NetworkNotification;

import javax.management.NotificationListener;
import javax.management.Notification;
import javax.management.NotificationFilter;

/**
 * MBeanRemovalListener is a listener for mbean removal events for a server and
 * when it is received, will destroy the client proxy
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1.2.1 $
 */
public class MBeanRemovalListener implements NotificationListener, NotificationFilter
{
    private final MBeanServerClientInvokerProxy proxy;

    MBeanRemovalListener (MBeanServerClientInvokerProxy proxy)
    {
        this.proxy = proxy;
    }
    public void handleNotification(Notification notification, Object object)
    {
        // we receieved a network failure event, remove it
        this.proxy.destroy();
    }

    public boolean isNotificationEnabled(Notification notification)
    {
        if (notification.getType().equals(NetworkNotification.SERVER_REMOVED))
        {
            NetworkNotification nn=(NetworkNotification)notification;
            return nn.getIdentity().getJMXId().equals(proxy.getServerId());
        }
        return false;
    }
}
