package org.jboss.test.mx.remoting.simple;

import org.jboss.mx.remoting.MBeanServerLocator;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.Detector;
import org.jboss.remoting.ident.Identity;

import javax.management.*;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class RemotingClient implements NotificationListener
{
   /**
    * Callback method from the broadcaster MBean this listener implementation
    * is registered to.
    *
    * @param notification the notification object
    * @param handback     the handback object given to the broadcaster
    *                     upon listener registration
    */
   public void handleNotification(Notification notification, Object handback)
   {
      Detection det = null;

      if (notification != null)
      {
         det = (Detection) notification.getUserData();
         if (Detector.SERVER_FOUND.equals(notification.getType()))
         {
            // found a server
            Identity ident = det.getIdentity();
            MBeanServerLocator locator = new MBeanServerLocator(ident);
            MBeanServer mbeansvr = locator.getMBeanServer();

            try
            {
               ObjectName objName = new ObjectName("test:type=RemotingServer");
               Object retVal = mbeansvr.invoke(objName, "sayHello", null, null);
               System.out.println("RemoteServer says: " + retVal);
            }
            catch (MalformedObjectNameException e)
            {
               e.printStackTrace();
            }
            catch (InstanceNotFoundException e)
            {
               e.printStackTrace();
            }
            catch (MBeanException e)
            {
               e.printStackTrace();
            }
            catch (ReflectionException e)
            {
               e.printStackTrace();
            }
         }
      }
   }
}
