/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import java.util.Arrays;

/**
 * Describes a notification emitted by an MBean
 *
 * This implementation protects its immutability by taking shallow clones of all arrays
 * supplied in constructors and by returning shallow array clones in getXXX() methods.
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author  <a href="mailto:trevor@protocool.com">Trevor Squires</a>.
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>
 *
 * @version $Revision: 1.2.8.2 $
 *
 * <p><b>Revisions:</b>
 * <p><b>20020711 Adrian Brock:</b>
 * <ul>
 * <li> Serialization </li>
 * </ul>
 */
public class MBeanNotificationInfo extends MBeanFeatureInfo
   implements Cloneable, java.io.Serializable
{
   // Constants -----------------------------------------------------

   private static final long serialVersionUID = -3888371564530107064L;

   // Attributes ----------------------------------------------------
   protected String[] types = null;

   /**
    * The cached string
    */
   private transient String cacheString;

   /**
    * The cached hashCode
    */
   private transient int cacheHashCode;

   // Constructors --------------------------------------------------
   public MBeanNotificationInfo(String[] notifsType,
                                String name,
                                String description)
   {
      super(name, description);
      
      this.types = (null == notifsType) ? new String[0] : (String[]) notifsType.clone();
   }

   // Public -------------------------------------------------------
   public String[] getNotifTypes()
   {
      return (String[]) types.clone();
   }

   public boolean equals(Object object)
   {
      if (this == object)
         return true;
      if (object == null || (object instanceof MBeanNotificationInfo) == false)
         return false;

      MBeanNotificationInfo other = (MBeanNotificationInfo) object;

      if (super.equals(other) == false)
         return false;

      String[] thisTypes = this.getNotifTypes();
      String[] otherTypes = other.getNotifTypes();
      if (thisTypes.length != otherTypes.length)
         return false;
      for (int i = 0; i < thisTypes.length; ++i)
         if (thisTypes[i].equals(otherTypes[i]) == false)
            return false;

      return true;
   }

   public int hashCode()
   {
      if (cacheHashCode == 0)
      {
         cacheHashCode =  super.hashCode();
      }
      return cacheHashCode;
   }

   /**
    * @return a human readable string
    */
   public String toString()
   {
      if (cacheString == null)
      {
         StringBuffer buffer = new StringBuffer(100);
         buffer.append(getClass().getName()).append(":");
         buffer.append(" name=").append(getName());
         buffer.append(" description=").append(getDescription());
         buffer.append(" types=").append(Arrays.asList(types));
         cacheString = buffer.toString();
      }
      return cacheString;
   }

   // CLoneable implementation -------------------------------------
   public Object clone() throws CloneNotSupportedException
   {
      MBeanNotificationInfo clone = (MBeanNotificationInfo) super.clone();
      clone.types = getNotifTypes();

      return clone;
   }
}
