/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import org.jboss.mx.server.MBeanServerBuilderImpl;

/**
 * The default builder for the MBeanServerFactory.<p>
 * 
 * To use a different builder, set the system property
 * javax.management.builder.initial and subclass this class.
 * 
 * @see javax.management.MBeanServer
 * @see javax.management.MBeanServerDelegate
 * @see javax.management.MBeanServerFactory
 * @see org.jboss.mx.server.MBeanServerImpl
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision: 1.5.2.1 $
 */
public class MBeanServerBuilder
{
   // Constants ---------------------------------------------------

   // Attributes --------------------------------------------------

   /**
    * Our implementation
    */
   MBeanServerBuilderImpl impl;

   // Static  -----------------------------------------------------

   // Constructors ------------------------------------------------

   /**
    * Construct an MBeanServerBuilder
    */
   public MBeanServerBuilder()
   {
   }

   /**
    * Construct an MBeanServer.
    *
    * @param defaultDomain the default domain when an MBean is
    *        registered with an ObjectName without a domain.
    * @param outer the wrapping MBeanServer, passed to MBeans
    *        at registration.
    * @param delegate the delegate to use for Notifications.
    */
   public MBeanServer newMBeanServer(String defaultDomain,
                                     MBeanServer outer,
                                     MBeanServerDelegate delegate)
   {
      if (impl == null)
         impl = new MBeanServerBuilderImpl();
      return impl.newMBeanServer(defaultDomain, outer, delegate);
   }

   /**
    * Construct an MBeanServerDelegate.
    */
   public MBeanServerDelegate newMBeanServerDelegate()
   {
      if (impl == null)
         impl = new MBeanServerBuilderImpl();
      return impl.newMBeanServerDelegate();
   }

   // Public ------------------------------------------------------

   // X Implementation --------------------------------------------

   // Y Overrides -------------------------------------------------

   // Protected ---------------------------------------------------

   // Package Private ---------------------------------------------

   // Private -----------------------------------------------------

   // Inner Classes -----------------------------------------------
}
