/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.loading;

/**
 * A classloader repository.<p>
 *
 * A loader repository per MBeanServer.
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @author  <a href="mailto:jplindfo@helsinki.fi">Juha Lindfors</a>.
 *
 * @version $Revision: 1.2.2.2 $
 *
 * <p><b>Revisions:</b>
 *
 * <p><b>20020224 Juha Lindfors:</b>
 * <ul>
 * <li>Updated to match JMX 1.2 specification.</li>
 * </ul>
 */
public interface ClassLoaderRepository
{
   /**
    * Loads a class from the repository. This method attempts to load the class
    * using all the classloader registered to the repository.
    *
    * @param className the class to load
    * @return the found class
    * @exception ClassNotFoundException when there is no such class
    */
   Class loadClass(String className) throws ClassNotFoundException;

   /**
    * Loads a class from the repository, excluding the given
    * classloader. 
    *
    * @param loader the classloader to exclude
    * @param className the class to load
    * @return the found class
    * @exception ClassNotFoundException when there is no such class
    */
   Class loadClassWithout(ClassLoader loader, String className)
      throws ClassNotFoundException;
   
   /**
    * Loads a class from the repository, using the classloaders that were
    * registered before the given classloader. 
    *
    * @param   stop      consult all the classloaders registered before this one
    *                    in an attempt to load a class
    * @param   className name of the class to load
    *
    * @return  loaded class instance
    *
    * @throws ClassNotFoundException if none of the consulted classloaders were
    *         able to load the requested class
    */
   Class loadClassBefore(ClassLoader stop, String className)
      throws ClassNotFoundException;      
}
