/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.loading;

import java.net.URL;
import java.net.URLStreamHandlerFactory;

/**
 *
 * @since JMX 1.2
 *
 * @see javax.management.loading.ClassLoaderRepository
 *
 * @author  <a href="mailto:jplindfo@helsinki.fi">Juha Lindfors</a>.
 * @version $Revision: 1.3.2.2 $
 */
public class PrivateMLet 
   extends MLet implements PrivateClassLoader
{
   
   public PrivateMLet(URL[] urls, boolean delegateToCLR) 
   {
      super(urls, delegateToCLR);
   }
   
   public PrivateMLet(URL[] urls, ClassLoader parent, boolean delegateToCLR) 
   {
      super(urls, parent, delegateToCLR);
   }
   
   public PrivateMLet(URL[] urls, ClassLoader parent,
                      URLStreamHandlerFactory factory, boolean delegateToCLR)
   {
      super(urls, parent, factory, delegateToCLR);
   }

   // Needed for java.io.Externalizable
   private PrivateMLet()
   {
   }
   
}

