/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.interceptor;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;


/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision: 1.5.2.1 $  
 */
public interface SharedInterceptor
   extends Interceptor, MBeanRegistration
{

   /**
    * Returns the object name of this shared interceptor.
    *
    * @return interceptor's object name
    */
   ObjectName getObjectName();
   
   /**
    * Returns the interceptor's view to the MBean server it has been
    * registered to.
    *
    * @return  interceptor's view to its MBean server
    */
   MBeanServer getMBeanServer();
   
   /**
    * Registers this interceptor to the given MBean server.
    *
    * @param   server   MBean server
    *
    * @return  the object name of the registered interceptor
    *
    * @throws InterceptorNameConflictException if an interceptor was already
    *         registered to the given server
    */
   ObjectName register(MBeanServer server) throws InterceptorNameConflictException;
   

}
      



