/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.notification;

import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/**
 * The notification listener registration for a listener in
 * the mbeanserver. The listener is proxied so we can
 * replace the source of the notification with the object name.<p>
 *
 * We also handle the registration with the broadcaster.
 * 
 * @see org.jboss.mx.notification.ListenerRegistry
 * @see org.jboss.mx.notification.ListenerRegistrationFactory
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision: 1.5.2.2 $
 */
public class MBeanServerListenerRegistration
   extends DefaultListenerRegistration
{
   // Attributes ----------------------------------------------------

   /**
    * The notification listener proxy
    */
   private NotificationListener proxy;

   private NotificationFilter filterProxy;

   /**
    * The notification broadcaster
    */
   private NotificationBroadcaster broadcaster;

   // Constructor ---------------------------------------------------

   /**
    * Create a listener registration
    *
    * @param name the object name to use as the notifiation source
    * @param broadcaster the notification broadcaster
    * @param listener the notification listener
    * @param filter the notification filter
    * @param handback the handback object  a
    */
   public MBeanServerListenerRegistration(ObjectName name,
                                          NotificationBroadcaster broadcaster,
                                          NotificationListener listener,
                                          NotificationFilter filter,
                                          Object handback)
   {
       super(listener, filter, handback);
       proxy = (NotificationListener) NotificationListenerProxy.newInstance(name, listener);
       this.broadcaster = broadcaster;
       this.filterProxy = (filter==null) ? null : new NotificationFilterProxy(name,filter);
       broadcaster.addNotificationListener(proxy, filterProxy, handback);
   }

   // Public --------------------------------------------------------

   // ListenerRegistration Implementation ---------------------------

   public NotificationListener getListener()
   {
      return proxy;
   }

    public NotificationFilter getFilter()
    {
        return filterProxy;
    }

   public void removed()
   {
      try
      {
         if (broadcaster instanceof NotificationEmitter)
            ((NotificationEmitter) broadcaster).removeNotificationListener(getListener(), getFilter(), getHandback());
         else
            broadcaster.removeNotificationListener(getListener());
      }
      catch (ListenerNotFoundException ignored)
      {
      }
   }
}
