package org.jboss.mx.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.MBeanInfo;
import org.apache.log4j.Logger;
import java.io.FileNotFoundException;

/**
 * MBean Info Object Database. <p>
 *
 * @author    Matt Munz
 */
public class MBeanInfoOdb
    extends Object
{
   protected Logger fLogger;

   // Constructors --------------------------------------------------
   
   public MBeanInfoOdb()
   {
      super();
   }

   // Protected -----------------------------------------------------
   
   protected void store(MBeanInfo metadata, File location) throws IOException
   {
       location.createNewFile();
       FileOutputStream fos = new FileOutputStream(location);
       ObjectOutputStream oos = new ObjectOutputStream(fos);
       oos.writeObject(metadata);
   }
   
   protected MBeanInfo load(File location) 
     throws IOException, FileNotFoundException, ClassNotFoundException
   {
       logger().info("Loading mbean info from location: " + location.getAbsolutePath());
       FileInputStream fis = new FileInputStream(location);
       ObjectInputStream ois = new ObjectInputStream(fis);
       MBeanInfo obj = (MBeanInfo) ois.readObject();
       ois.close();
       return obj;
   }

   protected Logger logger()
   {
      if (fLogger == null)
      {
         fLogger = Logger.getLogger("" + getClass().getName());
      }
      return fLogger;
   }
}

