/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.server;

public class InvocationException
    extends Exception
{

   // Attributes ----------------------------------------------------
   
   private Throwable t = null;

   
   // Constructors --------------------------------------------------
   
   public InvocationException(Throwable t)
   {
      super();
      this.t = t;
   }
   
   public InvocationException(Throwable t, String msg)
   {
      super(msg);
      this.t = t;
   }

   
   // Public --------------------------------------------------------
   
   public Throwable getTargetException()
   {
      return t;
   }

   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      return "InvocationException: " + ((getMessage() == null) ? "" : getMessage()) + 
                                       ((t == null) ? "" : "\nCause: " + t.toString());
   }
      
}
