package org.jboss.mx.server.registry;

import java.util.Enumeration;
import java.util.Vector;

import javax.management.ObjectName;

/**
 * In-Memory database of MBeanInfo objects.  
 * This is primarily used to store and load MBean info objects (and therefore, MBeans)
 * through the persistence manager attached to this object.
 * The MBean Registry delegates to this class the work of MBean Info persistence.
 * This class further delegates that task to it's persistence manager.  This allows
 * MBeanInfo persistence to be managed as part of the invocation stack via the 
 * Persistence Interceptor.
 * @author Matt Munz
 */
public class MbeanInfoDb extends Object
{
   protected Vector fMbInfosToStore;

   public MbeanInfoDb() 
   {
       super();
   } 
   
   public void add(ObjectName nameOfMbean)
   {
      mbInfosToStore().add(nameOfMbean);
   }

   public void add(Vector namesOfMbeans)
   {
      mbInfosToStore().addAll(namesOfMbeans);
   }

   /**
    * ObjectName objects bound to MBean Info objects that are waiting to be stored in the 
    * persistence store.
    */
   protected Vector mbInfosToStore()
   {
      if(fMbInfosToStore == null)
      {
         fMbInfosToStore = new Vector(10);
      }
      return fMbInfosToStore;
   }
   
   public Enumeration mbiPersistenceQueue()
   {
      return mbInfosToStore().elements();
   }
   
   public void removeFromMbiQueue(ObjectName name)
   {
       mbInfosToStore().remove(name);
   }   
}