/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.mx.util;

import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

/**
 * A simple helper to rethrow and/or decode those pesky 
 * JMX exceptions.
 *      
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @version $Revision: 1.1.2.3 $
 */
public class JMXExceptionDecoder
{
   /**
    * Attempt to decode the given Throwable.  If it
    * is a container JMX exception, then the target
    * is returned.  Otherwise the argument is returned.
    */
   public static Throwable decode(final Throwable t)
   {
      Throwable result = t;
      
      while (true)
      {
         if (result instanceof MBeanException)
            result = ((MBeanException) result).getTargetException();
         else if (result instanceof ReflectionException)
            result = ((ReflectionException) result).getTargetException();
         else if (result instanceof RuntimeOperationsException)
            result = ((RuntimeOperationsException) result).getTargetException();
         else if (result instanceof RuntimeMBeanException)
            result = ((RuntimeMBeanException) result).getTargetException();
         else if (result instanceof RuntimeErrorException)
            result = ((RuntimeErrorException) result).getTargetError();
         else
            // can't decode
            break;
      }

      return result;
   }

   /**
    * Decode and rethrow the given Throwable.  If it
    * is a container JMX exception, then the target
    * is thrown.  Otherwise the argument is thrown.
    */
   public static void rethrow(final Exception e)
      throws Exception
   {
      Throwable t = decode(e);
      if (t instanceof Exception)
         throw (Exception) t;
      else
         throw (Error) t;
   }
}
