/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.metadata;

import junit.framework.TestCase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import javax.management.MBeanParameterInfo;

/**
 * MBean Parameter Info tests.<p>
 *
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 */
public class MBeanParameterInfoTEST
  extends TestCase
{
   // Static --------------------------------------------------------------------

   // Attributes ----------------------------------------------------------------

   // Constructor ---------------------------------------------------------------

   /**
    * Construct the test
    */
   public MBeanParameterInfoTEST(String s)
   {
      super(s);
   }

   // Tests ---------------------------------------------------------------------

   public void testMBeanParameterInfo()
      throws Exception
   {
      MBeanParameterInfo info = new MBeanParameterInfo(
         "name", "type", "description");
      assertEquals("name", info.getName());
      assertEquals("type", info.getType());
      assertEquals("description", info.getDescription());
   }

   public void testHashCode()
      throws Exception
   {
      MBeanParameterInfo info1 = new MBeanParameterInfo("name", "type", "description");
      MBeanParameterInfo info2 = new MBeanParameterInfo("name", "type", "description");

      assertTrue("Different instances with the same hashcode are equal", info1.hashCode() == info2.hashCode());
   }

   public void testEquals()
      throws Exception
   {
      MBeanParameterInfo info = new MBeanParameterInfo(
         "name", "type", "description");

      assertTrue("Null should not be equal", info.equals(null) == false);
      assertTrue("Only MBeanParameterInfo should be equal", info.equals(new Object()) == false);

      MBeanParameterInfo info2 = new MBeanParameterInfo(
         "name", "type", "description");

      assertTrue("Different instances of the same data are equal", info.equals(info2));
      assertTrue("Different instances of the same data are equal", info2.equals(info));

      info2 = new MBeanParameterInfo(
         "name", "type", "description2");

      assertTrue("Different instances with different descriptions are not equal", info.equals(info2) == false);
      assertTrue("Different instances with different descritpions are not equal", info2.equals(info) == false);

      info2 = new MBeanParameterInfo(
         "name2", "type", "description");

      assertTrue("Instances with different names are not equal", info.equals(info2) == false);
      assertTrue("Instances with different names are not equal", info2.equals(info) == false);

      info2 = new MBeanParameterInfo(
         "name", "type2", "description");

      assertTrue("Instances with different types are not equal", info.equals(info2) == false);
      assertTrue("Instances with different types are not equal", info2.equals(info) == false);
   }

   public void testSerialization()
      throws Exception
   {
      MBeanParameterInfo info = new MBeanParameterInfo(
         "name", "type", "description");

      // Serialize it
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);
      oos.writeObject(info);
    
      // Deserialize it
      ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
      ObjectInputStream ois = new ObjectInputStream(bais);
      Object result = ois.readObject();

      assertEquals(info, result);
   }

   public void testErrors()
      throws Exception
   {
      boolean caught = false;
      try
      {
         MBeanParameterInfo info = new MBeanParameterInfo(
            null, "type", "description");
      }
      catch (IllegalArgumentException e)
      {
         caught = true;
      }
      if (caught == false)
         fail("Expected IllegalArgumentException for null name");

      caught = false;
      try
      {
         MBeanParameterInfo info = new MBeanParameterInfo(
            "", "type", "description");
      }
      catch (IllegalArgumentException e)
      {
         caught = true;
      }
      if (caught == false)
         fail("Expected IllegalArgumentException for an empty name");

      caught = false;
      try
      {
         MBeanParameterInfo info = new MBeanParameterInfo(
            "invalid name", "type", "description");
      }
      catch (IllegalArgumentException e)
      {
         caught = true;
      }
      if (caught == false)
         fail("Expected IllegalArgumentException for an 'invalid name'");

      caught = false;
      try
      {
         MBeanParameterInfo info = new MBeanParameterInfo(
            "name", null, "description");
      }
      catch (IllegalArgumentException e)
      {
         caught = true;
      }
      if (caught == false)
         fail("Expected IllegalArgumentException for null type");

      caught = false;
      try
      {
         MBeanParameterInfo info = new MBeanParameterInfo(
            "name", "", "description");
      }
      catch (IllegalArgumentException e)
      {
         caught = true;
      }
      if (caught == false)
         fail("Expected IllegalArgumentException for an empty type");

      caught = false;
      try
      {
         MBeanParameterInfo info = new MBeanParameterInfo(
            "name", "invalid type", "description");
      }
      catch (IllegalArgumentException e)
      {
         caught = true;
      }
      if (caught == false)
         fail("Expected IllegalArgumentException for an 'invalid type'");
   }
}
