/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.notification;

import javax.management.AttributeChangeNotificationFilter;

import junit.framework.TestCase;

/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 */
public class AttributeChangeNotificationFilterTestCase
  extends TestCase
{

  // Constructor ---------------------------------------------------------------

  /**
   * Construct the test
   */
  public AttributeChangeNotificationFilterTestCase(String s)
  {
    super(s);
  }

  // Tests ---------------------------------------------------------------------

  public void testGetEnabledAttributes()
  {
      AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
      
      assertTrue(filter.getEnabledAttributes().size() == 0);
      
      filter.enableAttribute("foo");
      filter.enableAttribute("bar");
      
      assertTrue(filter.getEnabledAttributes().size() == 2);
  }

  public void testDisableAttribute()
  {
     AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
     
     filter.enableAttribute("foo");
     filter.enableAttribute("bar");
     
     assertTrue(filter.getEnabledAttributes().size() == 2);
     
     filter.disableAttribute("foo");
     
     assertTrue(filter.getEnabledAttributes().size() == 1);
     assertTrue(filter.getEnabledAttributes().get(0).equals("bar"));
     
     filter.disableAllAttributes();
     
     assertTrue(filter.getEnabledAttributes().size() == 0);
     
  }

}
