/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.server.support;

import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

/**
 * An alternate builder
 *
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision: 1.3.2.1 $
 */
public class TestMBeanServerBuilder
   extends MBeanServerBuilder
{
   public TestMBeanServerBuilder()
   {
   }

   public MBeanServer newMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate)
   {
      MBeanServer original = super.newMBeanServer(domain, outer, delegate);
      MBeanServer wrapper = MBeanServerWrapper.getWrapper();
      MBeanServerWrapper.getHandler(wrapper).server = original;
      return wrapper;
   }

   public MBeanServerDelegate newMBeanServerDelegate()
   {
      return new TestMBeanServerDelegate();
   }
}
