/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

/**
 * This class implements javax.jms.QueueReceiver
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.3.2.1 $
 */
public class SpyQueueReceiver extends SpyMessageConsumer implements QueueReceiver
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   /**
    * Create a new SpyQueueReceiver
    *
    * @param session the session
    * @param queue the queue
    * @param selector the message selector
    * @throws InvalidSelectorException for an invalid message selector
    */
   SpyQueueReceiver(SpySession session, Queue queue, String selector) throws InvalidSelectorException
   {
      super(session, false, (SpyDestination) queue, selector, false);
   }
   
   // Public --------------------------------------------------------
   
   // QueueReceiver implementation ----------------------------------

   public Queue getQueue() throws JMSException
   {
      if (closed)
         throw new IllegalStateException("The MessageConsumer is closed");

      return (Queue) subscription.destination;
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------

}