/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

/**
 * This class implements javax.jms.QueueSender
 * 
 * A sender created with a null Queue will now be interpreted as created as an
 * unidentifyed sender and follows the spec in throwing
 * UnsupportedOperationException at the correct places.
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="pra@tim.se">Peter Antman</a>
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.4.4.1 $
 */
public class SpyQueueSender extends SpyMessageProducer implements QueueSender
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   /**
    * Create a new SpyQueueSender
    *
    * @param session the session
    * @param queue the queue
    */
   SpyQueueSender(SpySession session, Queue queue)
   {
      super(session, queue);
   }
   
   // Public --------------------------------------------------------
   
   // QueueSender implementation ------------------------------------

   public Queue getQueue() throws JMSException
   {
      return (Queue) getDestination();
   }

   public void send(Queue queue, Message message) throws JMSException
   {
      send((Destination) queue, message);
   }

   public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException
   {
      send((Destination) queue, message, deliveryMode, priority, timeToLive);
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------

}